 /***************************************************
 *
 *  DESCRIPTION: Atomic Model Base Station Processor
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 25/10/2012
 *
 ****************************************************/

 #include "BSprocessor.h"
 #include "message.h"       // InternalMessage ....
 #include <iostream>
 #include <fstream>
 ofstream BRP ("BS0ProsRec.txt");
 ofstream BSP ("BS0ProsSend.txt");

 BSprocessor::BSprocessor( const std::string &name ) : Atomic( name )
 , In( addInputPort( "In" ) )
 , Req( addInputPort( "Req" ) )
 , OB1( addInputPort( "OB1" ) )
 , OB2( addInputPort( "OB2" ) )
 , OB3( addInputPort( "OB3" ) )
 , OB4( addInputPort( "OB4" ) )
 , OB5( addInputPort( "OB5" ) )
 , OB6( addInputPort( "OB6" ) )
 , OU0( addInputPort( "OU0" ) )
 , ProcessTime (00,00,00,02)
 {
 }

 Model &BSprocessor::initFunction()
  {
    state = AskNewTask;	// waiting for new task
    Temp = 1;
    CurrentCell = 0;
    for (i=0;i<7;i++)
    	for (j=0;j<7;j++)
    		UEinBS [i][j] = 0;
    UEinBS [0][0] = 1;
    UEinBS [2][1] = 1;
    UEinBS [4][2] = 1;
    NextHop [0] = 0;
    NextHop [1] = 1;
    NextHop [2] = 2;
    NextHop [3] = 3;
    NextHop [4] = 4;
    NextHop [5] = 5;
    NextHop [6] = 6;
    NextHop [7] = 7;
    NextHop [8] = 2;
    NextHop [9] = 4;
    for (i = 0;i < 7;i++) Neighborhood [i] = 1;
    for (i = 0;i < 3;i++) MyUEMode [i] = 0;
    for (i = 0;i < 3;i++)
    	for (j = 0;j < 3;j++) UECoordinationSet [i][j] = 0;
    Turn = 0;
    holdIn(Atomic::active, 0);  //Programmed to have an instantaneous internal transition.
	return *this ;
  }

 Model &BSprocessor::externalFunction( const ExternalMessage &msg )
 { BRP <<msg.time()<<" "<<msg.value()<<"\n";
   Temp = msg.value();
   for (i=0;i<6;i++)
   {
	 Digit [i] = Temp % 10;
	 Temp = Temp / 10;
   }

   if (Digit [3] == 0 || Digit [3] == 1) //It is a Data/ACK packet from one UE to another UE.Forward it to its Destination. If it is this BS UE consider UE mode.
   {
	 for (i=0;i<7;i++)   //UE is in which Cell?
	      if (UEinBS [i][Digit[4]] == 1 ) Temp = i;
	 if (Temp == CurrentCell ) //If UE is in this Cell.
     {
	   if (MyUEMode [Digit [4]] == 1) //UE is in CoMP Mode.
	   {
		 state = SetCSMode;   //  srcBS desBS BSMsg X X UE
		 BSMes1 = 114000;  //Send Message for Other BS in Cooperation Set to not interfere with this UE.
		 BSMes1 = BSMes1 + ( UECoordinationSet[Digit[4]][0] * 100 ) + ( UECoordinationSet[Digit[4]][1] * 10 ) + Digit[4];
		 BSMes1Port = UECoordinationSet[Digit[4]][1];   // OutPort to BS
		 BSMes2 = 114000;
		 BSMes2 = BSMes2 + ( UECoordinationSet[Digit[4]][0] * 100 ) + ( UECoordinationSet[Digit[4]][2] * 10 ) + Digit[4];
		 BSMes2Port = UECoordinationSet[Digit[4]][2];   // OutPort to BS
		 OutPort = NextHop [7 + Digit [4]];  //Find the output port from this BS to destination UE.
	   }
	   else
           {
		     state = NormalMode;
		     OutPort = NextHop [7 + Digit [4]]; //UE is in normal mode send the message directly to UE.
           }
	 }
	 else
	     {
		   OutPort = NextHop [7 + Digit [4]]; //UE is not in this cell so send it for its serving BS.
		   state = NormalMode;
		 }
	 Temp = msg.value();
   }

   if (Digit [3] == 2)  //It is a packet from a BS to a UE. Forward it.
   {
     state = NormalMode;
     OutPort = NextHop [7 + Digit [4]];
     Temp = msg.value();
   }

   if (Digit [3] == 3)  //It is a packet from a UE to a BS. One of your UE send it for you so work on it.
   {
	 if (Digit [5] == 0) //UE wants to leave this cell. The destination cell for UE is in Digit[4];
	 {
	   UEinBS [CurrentCell][Digit[2]]	= 0;
	   UEinBS [Digit [4]][Digit[2]]	= 1;
	   NextHop [7 + Digit[2]] = NextHop [Digit [4]];
	   state = InfoMode;
	   Temp = 104000 + (CurrentCell * 100) + (Digit [4] * 10) + Digit [2];    //104160--> UE 0 wants to go to Cell 6 from Cell 1.
	 }
	 else if (Digit [4] == 1)  //UE wants to stays in this cell and it is want to use CoMP Mode.
	      {
		    MyUEMode [(Digit [5] - 1)] = 1;                     //Change UE Mode.
		    Temp = msg.value();
		    Temp = Temp % 10;                            //Specify Coordination Set for UE.
		    UECoordinationSet [(Digit[5] - 1)][0] = Temp;       //set Serving BS
		    Temp = msg.value();
		    Temp = (Temp / 10) % 10;
		    UECoordinationSet [(Digit[5] - 1)][1] = Temp;       //set Cooperative BS
		    Temp = msg.value();
		    Temp = (Temp / 100) % 10;
		    UECoordinationSet [(Digit[5] - 1)][2] = Temp;       //set Cooperative BS
		    Temp = 1;
		    state = AskNewTask;
	      }
	      else if (Digit [4] == 0)  //UE wants to stays in this cell and it wants to use Normal Mode.
	           {
	    	     MyUEMode [(Digit [5] - 1)] = 0;
	    	     Temp = 1;
	    	     state = AskNewTask;
	           }
   }

   if (Digit [3] == 4 )  // It is info packet from one BS to other BS.
   {
	  if (Digit [4] == 0) //It is broadcast packet about UE changes. If there is new info Work on it and send it for your neighbors
	  {
		if ( (UEinBS [Digit[1]][Digit[0]] == 1) && (UEinBS [Digit[2]][Digit[0]] == 0) )   //There is no new info in this message.
		{
		  Temp = 1;
		  state = AskNewTask;
		}
		else
		   {
			 UEinBS [Digit[1]][Digit[0]] = 1;
			 UEinBS [Digit[2]][Digit[0]] = 0;
			 if (Digit [1] == CurrentCell ) NextHop [7 + Digit[0]] = 7 + Digit [0];
				 else NextHop [7 + Digit[0]] = NextHop [Digit [1]];
			 state = InfoMode;
			 Temp = msg.value();
		   }
	  }
	  else if (Digit [4] == 1)
	       {
		     state = AskNewTask;   //This is the part to avoid the interference....Nothing fo rnow. Just receive the message.
		     Temp = 1;
	       }
   }

	holdIn(Atomic::active, ProcessTime);
	return *this;
  }

 Model &BSprocessor::outputFunction( const InternalMessage &msg )
 {
   if (state == SetCSMode)
   {
	       BSP <<msg.time()<<" "<<BSMes1Port<<" "<<BSMes1<<"\n";
	       if (BSMes1Port == 1) sendOutput( msg.time(), OB1, BSMes1) ;
	         else if (BSMes1Port == 2) sendOutput( msg.time(), OB2, BSMes1) ;
	              else if (BSMes1Port == 3) sendOutput( msg.time(), OB3, BSMes1) ;
	                   else if (BSMes1Port == 4 ) sendOutput( msg.time(), OB4, BSMes1) ;
	                        else if (BSMes1Port == 5) sendOutput( msg.time(), OB5, BSMes1) ;
	                             else if (BSMes1Port == 6) sendOutput( msg.time(), OB6, BSMes1) ;

	       BSP <<msg.time()<<" "<<BSMes2Port<<" "<<BSMes2<<"\n";
	       if (BSMes2Port == 1) sendOutput( msg.time(), OB1, BSMes2) ;
	         else if (BSMes2Port == 2) sendOutput( msg.time(), OB2, BSMes2) ;
	              else if (BSMes2Port == 3) sendOutput( msg.time(), OB3, BSMes2) ;
	                   else if (BSMes2Port == 4 ) sendOutput( msg.time(), OB4, BSMes2) ;
	                        else if (BSMes2Port == 5) sendOutput( msg.time(), OB5, BSMes2) ;
	                             else if (BSMes2Port == 6) sendOutput( msg.time(), OB6, BSMes2);

   }

   if (state == NormalMode)
   {     BSP <<msg.time()<<" "<<OutPort<<" "<<Temp<<"\n";
	     if (OutPort == 1) sendOutput( msg.time(), OB1, Temp) ;
		     else if (OutPort == 2) sendOutput( msg.time(), OB2, Temp) ;
		          else if (OutPort == 3) sendOutput( msg.time(), OB3, Temp) ;
		               else if (OutPort == 4) sendOutput( msg.time(), OB4, Temp) ;
		                    else if (OutPort == 5) sendOutput( msg.time(), OB5, Temp) ;
		                         else if (OutPort == 6) sendOutput( msg.time(), OB6, Temp) ;
		                              else if (OutPort == 7) sendOutput( msg.time(), OU0, Temp) ;
   }

   if (state == InfoMode)
   {
	 for (i = 0;i < 7;i++)
		 if (Neighborhood [i] == 1)
		 {    BSP <<msg.time()<<" "<<OutPort<<" "<<Temp<<"\n";
			  if (NextHop[i] == 1) sendOutput( msg.time(), OB1, Temp) ;
			       else if (NextHop[i] == 2) sendOutput( msg.time(), OB2, Temp) ;
				        else if (NextHop[i] == 3) sendOutput( msg.time(), OB3, Temp) ;
				             else if (NextHop[i] == 4) sendOutput( msg.time(), OB4, Temp) ;
				                  else if (NextHop[i] == 5) sendOutput( msg.time(), OB5, Temp) ;
				                       else if (NextHop[i] == 6) sendOutput( msg.time(), OB6, Temp) ;
		 }
   }

   if (state == AskNewTask)
   {
	  sendOutput( msg.time(), Req, Temp) ;
	  BSP <<msg.time()<<" Req "<<Temp<<"\n";
   }
   return *this ;
 }

 Model &BSprocessor::internalFunction( const InternalMessage & )
 {
	switch (state){
				    case Idle:
				    	       passivate();
					           break;

				    case SetCSMode:
				    	             state = NormalMode;
				    	             holdIn(Atomic::active, ProcessTime);
					                 break;
				    case NormalMode:
   				    	             state = AskNewTask;
   				    	             Temp = 1;
				    	             break;
				    case InfoMode:
				                     state = AskNewTask;
				       				 Temp = 1;
				    				 break;
				    case AskNewTask:
				       				 state = Idle;
				    				 break;
        		  }
    return *this;
 }

 BSprocessor::~BSprocessor()
{
}
